<?php 
session_start();

if(!$_SESSION['u_logeado']) {
	header("location:../login.php");
	exit();
}
include_once "header.php";
?>
<div style="margin: 0 2% 0 2%" id="app">
	<!-- Main container -->
	<nav class="level mt-5">
	  <!-- Left side -->
	  <div class="level-left">
	    <div class="level-item">
	      <p class="title is-2"><strong>{{ totalItems }}</strong> Ventas</p>
	    </div>
	    <div class="level-item">
	      
	         <input class="input" type="text" placeholder="Escribe algo..." v-model="searchQuery" @input="onBuscaPalabra" />

	    </div>
	    <div class="level-item">
	    	<div class="select">
			  <select v-model="perPage" @change="onCambiaPerPage">
			    <option>1</option>
			    <option>5</option>
			    <option>10</option>
			    <option>20</option>
			    <option>50</option>
			    <option>100</option>
			    <option>200</option>
			  </select>
			</div>
	    </div>
	  </div>

	  <!-- Right side -->
	  <div class="level-right">
	    <p class="level-item is-clickable" id="filtro-Todas" @click=" establecerFiltro('Todas')">Todas</p>
	    <p class="level-item is-clickable" id="filtro-Activas" @click=" establecerFiltro('Activas')">Activas</p>
	    <p class="level-item is-clickable" id="filtro-Vencidas" @click=" establecerFiltro('Vencidas')">Vencidas</p>
	    <p class="level-item is-clickable" id="filtro-Vencer" @click=" establecerFiltro('Vencer')">Vencer</p>
	    <p class="level-item">
	    	<a class="button is-success" @click=" verModal = true ">
	    		<i class="fa fa-plus"></i>&nbsp	
	    		Nueva venta
	    	</a>
	    </p>
	    <p class="level-item">
	    	<a class="button is-primary" @click=" verImportar = true ">
	    		<i class="fa fa-upload"></i>&nbsp	
	    		Importar
	    	</a>
	    </p>
	    <p class="level-item">
	    	<a class="button is-dark" @click="exportar">
	    		<i class="fa fa-download"></i>&nbsp	
	    		Exportar
	    	</a>
	    </p>
	  </div>
	</nav>
	<div class="notification is-link" v-if="ventas.length < 1">
	 
	 <p class="title has-text-centered">NO SE HAN ENCONTRADO VENTAS</p>
	</div>
	<div v-if="ventas.length > 0">
	<nav class="level is-mobile">
	  <div class="level-item has-text-centered">
	    <div>
	      <p class="heading">Activas</p>
	      	<div class="tags has-addons are-large">
			  <span class="tag has-text-success-dark has-text-weight-bold">{{ estados.activas}}</span>
			  <span class="tag is-success has-text-weight-bold">{{ estados.total_activas }}</span>
			</div>
	    </div>
	  </div>

	  <div class="level-item has-text-centered">
	    <div>
	      <p class="heading">Por vencer</p>
	      <div class="tags has-addons are-large">
			  <span class="tag has-text-warning-dark has-text-weight-bold">{{ estados.vencer}}</span>
			  <span class="tag is-warning has-text-weight-bold">{{ estados.total_vencer }}</span>
			</div>
	    </div>
	  </div>

	  <div class="level-item has-text-centered">
	    <div>
	      <p class="heading">Vencidas</p>
	      <div class="tags has-addons are-large">
			  <span class="tag has-text-danger-dark has-text-weight-bold">{{ estados.vencidas}}</span>
			  <span class="tag is-danger has-text-weight-bold">{{ estados.total_vencidas }}</span>
			</div>
	    </div>
	  </div>

	  <div class="level-item has-text-centered">
	    <div>
	      <p class="heading">Total ventas</p>
	      <p class="title has-text-weight-bold is-1 has-text-primary-dark">{{ estados.total_ventas}}</p>
	    </div>
	  </div>
	</nav>
	<div class="box">
	<table class="table is-bordered is-striped is-narrow is-hoverable is-fullwidth">
		<thead>
			<th>Cliente</th>	
			<th>Whatsapp</th>
			<th>Plataforma</th>	
			<th>Dispositivos</th>	
			<th>Precio</th>	
			<th>Usuario</th>	
			<th>Contraseña</th>	
			<th>Fecha Inicio</th>	
			<th>Fecha Fin</th>	
			<th>Dias Restantes</th>	
			<th>Estado</th>	
			<th>Observacion</th>	
			<th>Opciones</th>	
			<th class="is-size-7">Enviar datos/Recordatorio </th>
		</thead>
		<tbody>
			<tr v-for="venta in ventas" :key="venta.id_venta" >
				<td>{{venta.cliente}}</td>
				<td>{{venta.whatsapp}}</td>
				<td>{{venta.plataforma}}</td>
				<td class="has-text-centered">{{venta.no_dispositivos}}</td>
				<td class="has-text-weight-bold">{{venta.precio}}</td>
				<td>{{venta.usuario}}</td>
				<td>{{venta.password}}</td>
				<td>{{venta.fecha_inicio}}</td>
				<td>{{venta.fecha_fin}}</td>
				<td class="has-text-centered has-text-weight-bold" :class="{
					'has-text-success-dark': parseInt(venta.dias_restantes) >= 4,
					'has-text-warning-dark': parseInt(venta.dias_restantes) >= 1 && parseInt(venta.dias_restantes) < 4,
					'has-text-danger-dark': parseInt(venta.dias_restantes) < 1 ,
				}">
					{{venta.dias_restantes}}
				</td>
				<td>
					<span class="tag " :class="{
						'is-success': venta.estado_venta === 'ACTIVA',
						'is-danger': venta.estado_venta === 'VENCIDA',
						'is-warning': venta.estado_venta === 'VENCER'
					}">
						{{venta.estado_venta}}
					</span>
				</td>
				<td>{{venta.observaciones}}</td>
				<td>
					<button class="button is-info is-outlined is-small" @click="editar(venta)">
						<i class="fa fa-edit"></i>
					</button>
					<button class="button is-danger is-outlined is-small" @click="eliminar(venta)">
						<i class="fa fa-trash"></i>
					</button>
				</td>
				<td>
					<button class="button is-primary is-outlined is-small" @click="enviarDatos(venta)">
						<i class="fa fa-share"></i>
					</button>
					<button class="button is-dark is-outlined is-small" @click="enviarRecordatorio(venta)">
						<i class="fa fa-bell"></i>
					</button>
				</td>
			</tr>
		</tbody>
	</table>
	<nav class="pagination is-right is-rounded" role="navigation" aria-label="pagination">
	  <a class="pagination-previous" @click="prevPage" :disabled="currentPage === 1">Anterior</a>
	  <a class="pagination-next" @click="nextPage" :disabled="currentPage === totalPages">Siguiente</a>
	  <ul class="pagination-list">
	    <li v-for="pageNumber in totalPages" :key="pageNumber">
	      <a class="pagination-link" @click="setCurrentPage(pageNumber)" :class="{ 'is-current': currentPage === pageNumber }">{{ pageNumber }}</a>
	    </li>
	  </ul>
	</nav>
	</div>
	</div>

	<div class="modal" :class="{'is-active': verModal}">
  		<div class="modal-background"></div>
		  <div class="modal-card">
		    <header class="modal-card-head has-background-dark">
		      <p class="modal-card-title  has-text-white">{{ accionModal }} Venta</p>
		      <button class="delete" aria-label="close" @click=" cerrarModal "></button>
		    </header>
		    <section class="modal-card-body">
		    	<div class="columns">
		    		<div class="column">
		    			<div class="field">
					  <label class="label">Cliente*</label>
					  <div class="control has-icons-left">
					    <input v-model="venta.cliente" class="input" type="text" placeholder="Nombre del cliente" >
					    <span class="icon is-small is-left">
					      <i class="fas fa-user"></i>
					    </span>
					  </div>
					</div>
		    		</div>
		    		<div class="column">
		    			<div class="field">
					  <label class="label">WhatsApp</label>
					  <div class="control has-icons-left">
					    <input v-model="venta.whatsapp" class="input" type="text" placeholder="Teléfono del cliente" >
					    <span class="icon is-small is-left">
					      <i class="fa-brands fa-whatsapp"></i>
					    </span>
					  </div>
					</div>
		    		</div>
		    	</div>
		    	<div class="columns">
		    		<div class="column">
		    			<div class="field">
					  <label class="label">Plataforma*</label>
					  <div class="control has-icons-left">
					    <input v-model="venta.plataforma" class="input" type="text" placeholder="Plataforma" >
					    <span class="icon is-small is-left">
					      <i class="fas fa-bowl-rice"></i>
					    </span>
					  </div>
					</div>
		    		</div>
		    		<div class="column">
		    		  <div class="field">
					  	<label class="label">No. Dispositivos*</label>
					  	<div class="control has-icons-left">
					   		<input v-model="venta.noDispositivos" class="input" type="text" placeholder="Dispositivos" >
					    	<span class="icon is-small is-left">
					      		<i class="fa-solid fa-house-laptop"></i>
					    	</span>
					  	</div>
		    			</div>
		    		</div>
		    		<div class="column">
		    			<div class="field">
					  		<label class="label">Precio*</label>
					  		<div class="control has-icons-left">
							    <input v-model="venta.precio" class="input" type="text" placeholder="Precio" >
							    <span class="icon is-small is-left">
							      <i class="fa-solid fa-money-bill"></i>
							    </span>
					  		</div>
						</div>
		    		</div>
		    	</div>
			
		    	<div class="columns">
		    		<div class="column">
		    			<div class="field">
					  <label class="label">Usuario*</label>
					  <div class="control has-icons-left">
					    <input v-model="venta.usuario" class="input" type="text" placeholder="Usuario cuenta" >
					    <span class="icon is-small is-left">
					      <i class="fas fa-user-astronaut"></i>
					    </span>
					  </div>
					</div>
		    		</div>
		    		<div class="column">
		    			<div class="field">
					  <label class="label">Contraseña*</label>
					  <div class="control has-icons-left">
					    <input v-model="venta.contrasenia" class="input" type="text" placeholder="************" >
					    <span class="icon is-small is-left">
					      <i class="fa-solid fa-key"></i>
					    </span>
					  </div>
					</div>
		    		</div>
		    	</div>

		    	<div class="columns">
		    		<div class="column">
		    			<div class="field">
					  <label class="label">Fecha inicio*</label>
					  <div class="control has-icons-left">
					    <input v-model="venta.fechaInicio" class="input" type="date"  >
					    <span class="icon is-small is-left">
					      <i class="fas fa-calendar"></i>
					    </span>
					  </div>
					</div>
		    		</div>
		    		<div class="column">
		    			<div class="field">
						  <label class="label">Fecha Fin*</label>
						  <div class="control has-icons-left">
						    <input v-model="venta.fechaFin" class="input" type="date" >
						    <span class="icon is-small is-left">
						      <i class="fa-solid fa-calendar"></i>
						    </span>
						  </div>
						</div>
		    		</div>
		    	</div>

		    	<div class="field">
		    		<label class="label">Observaciones</label>
		    		<textarea class="textarea" v-model="venta.observacion" placeholder="Observaciones de la venta"></textarea>
		    	</div>


				
		    </section>
		    <footer class="modal-card-foot ">
		      <button class="button is-success" @click="registrar">
		      	<span>Agregar</span>
		      </button>
		      <button class="button is-dark" @click=" cerrarModal ">Cerrar</button>
		    </footer>
		  </div>
	</div>

	<div class="modal" :class="{'is-active': verImportar}">
	  <div class="modal-background"></div>
	  <div class="modal-card">
	    <header class="modal-card-head">
	      <p class="modal-card-title">Importar Ventas</p>
	      <button class="delete" aria-label="close" @click=" verImportar = false "></button>
	    </header>
	    <section class="modal-card-body">
	    	<div class="has-text-centered mb-3">
		    	<a href="../files/carga_ventas.csv" class="button ">Descargar ejemplo</a>
		    </div>

			<div class="file is-centered mt-5">
              <label class="file-label">
                <input class="file-input" type="file" @change="manejarInput" accept=".csv">
                <span class="file-cta">
                   <i class="fa fa-upload"></i>
                  <span class="file-label">
                    Selecciona un archivo…
                  </span>
                </span>
              </label>
            </div>
	    </section>
	    <footer class="modal-card-foot">
	      <div class="buttons">
	        <button class="button is-success" @click="importar">Importar ventas</button>
	        <button class="button" @click=" verImportar = false ">Cancelar</button>
	      </div>
	    </footer>
	  </div>
	</div>
</div>
<?php include_once "footer.php"?>
<script>
new Vue({
	el: "#app",
	data:()=> ({
		verImportar: false,
		verModal: false,
		accionModal: 'Agregar',
		venta: {
			cliente: "",
			whatsapp: "",	
			plataforma: "",
			noDispositivos: "",	
			precio: "",	
			usuario: "",
			contrasenia: "",
			fechaInicio: "",	
			fechaFin: "",	
			observacion: ""
		},
		ventas: [],
		estados: {},
		currentPage: 1,
		totalItems: 0,
		perPage: 20,
		searchQuery: "",
		filtroEstado: "Todas",
		clasesFiltros :[ 'has-text-weight-bold', 'has-text-info', 'activa' ],
		archivo: null
	}),

	mounted(){
		this.obtener()
		document.querySelector('#filtro-Todas').classList.add(...this.clasesFiltros)
	},

	methods: {
		enviarDatos(venta){
			let msg = `Hola ¡Gracias por elegirnos! Estimado/a ${venta.cliente} Nos complace darle la bienvenida a nuestra familia de clientes ${venta.plataforma}, aquí están sus credenciales: |USUARIO: ${venta.usuario}| CONTRASEÑA: ${venta.password}| VENCIMIENTO : ${venta.fecha_fin}| Para una mejor experiencia NO COMPARTAS TU ACCESO O PODRIAS SER BANEADO`
			const win = window.open(`https://wa.me/${venta.whatsapp}?text=${msg}`, '_blank');
		},

		enviarRecordatorio(venta){
			let msg = `Asunto: Aviso de renovación de su servicio - Buen día estimado/a, ${venta.cliente}, STREAMING LATINO le recuerda que su servicio ${venta.plataforma} vence el día ${venta.fecha_fin}. Vence en ${venta.dias_restantes} días. Para asegurar de que siga disfrutando de nuestros servicios sin interrupciones, le recomendamos renovar su Membresía. Agradecemos su preferencia. Nos confirma su renovación para seguir brindándole nuestros servicios.`
			const win = window.open(`https://wa.me/${venta.whatsapp}?text=${msg}`, '_blank');
		
		},

		exportar(){
			window.location.href = `../controller/exportar_ventas.php?estado=${this.filtroEstado}`
		},

		importar(){
			if (this.archivo) {
                try {
                    let reader = new FileReader();
                   
                    reader.onload = async (event) => {

                        let base64Data = event.target.result.split(',')[1];

                        let payload = {
                            accion: 'importar',
                            archivo: base64Data,
                        };

                        let respuesta = await fetch("../controller/Ventas.php",{
							method: "POST",
							headers: {
		                        "Content-Type": "application/json"
		                    },
							body: JSON.stringify(payload)
						})

						let resultado = await respuesta.json()

                        

                        if (resultado.estado) {
                            Swal.fire({
							  position: "top-end",
							  icon: "success",
							  title:  "Correcto, ventas importadas" ,
							  showConfirmButton: false,
							  timer: 5000
							})
                            
                            this.obtener()
                            this.archivo = null
                            this.verImportar = false
                        } else {
                            alert("Error al importar los datos: " + respuesta.respuesta);
                        }
                    };

                    // Leer el contenido del archivo como base64
                    reader.readAsDataURL(this.archivo);
                } catch (error) {
                    alert("Error al importar los datos: " + error.message);
                } finally {
                    console.log("Todo bien")
                    this.archivo = null
                }
            } else {
                alert('Por favor, seleccione un archivo CSV.');
            }
		},

		manejarInput(event) {
            this.archivo = event.target.files[0]
            alert("Archivo seleccionado")

        },

		establecerFiltro(estado){
			this.filtroEstado = estado
			
			const elements = document.querySelectorAll('.activa');

			elements.forEach(element => {
			  if (element.textContent.trim() !== 'estado') {
			    element.classList.remove(...this.clasesFiltros);
			  }
			})

			let etiqueta = document.querySelector('#filtro-'+estado)
			etiqueta.classList.add(...this.clasesFiltros)

			//console.log(this.filtroEstado)
			this.obtener()
		},

		onBuscaPalabra(){
			this.obtener()
		}, 

		onCambiaPerPage(){
			this.obtener()
		},

		nextPage() {
          if (this.currentPage < this.totalPages) {
            this.currentPage += 1;
            this.obtener()
          }
        },
        prevPage() {
          if (this.currentPage > 1) {
            this.currentPage -= 1;
            this.obtener()
          }
        },
        setCurrentPage(pageNumber) {
          this.currentPage = pageNumber;
          this.obtener()
        },

		cerrarModal(){
			this.verModal = false
			this.venta = {
				cliente: "",
				whatsapp: "",	
				plataforma: "",
				noDispositivos: "",	
				precio: "",	
				usuario: "",
				contrasenia: "",
				fechaInicio: "",	
				fechaFin: "",	
				observacion: ""
			},
			this.accionModal = 'Agregar'
		},
		editar(venta){
			this.venta = {
				id: venta.id_venta,
				cliente: venta.cliente,
				whatsapp: venta.whatsapp,	
				plataforma: venta.plataforma,
				noDispositivos: venta.no_dispositivos,	
				precio: venta.precio,	
				usuario: venta.usuario,
				contrasenia: venta.password,
				fechaInicio: venta.fecha_inicio,	
				fechaFin: venta.fecha_fin,	
				observacion: venta.observaciones
			}
			this.accionModal = 'Editar'
			this.verModal = true
		},

		eliminar(venta){
			Swal.fire({
			  title: `¿Seguro que deseas eliminar la venta del cliente ${venta.cliente} con el producto ${venta.plataforma}?`,
			  text: "¡Esta acción no se puede deshacer!",
			  icon: "warning",
			  showCancelButton: true,
			  confirmButtonColor: "#3085d6",
			  cancelButtonColor: "#d33",
			  confirmButtonText: "Sí, eliminar",
			  cancelButtonText: "Cancelar"
			}).then(async (result) => {
			  if (result.isConfirmed) {
			    try{
			    	let respuesta = await fetch("../controller/Ventas.php",{
						method: "POST",
						headers: {
	                        "Content-Type": "application/json"
	                    },
						body: JSON.stringify({ accion: 'eliminar', idVenta: venta.id_venta})
					})

					let resultado = await respuesta.json()
					if(resultado){
						Swal.fire({
						  position: "top-end",
						  icon: "success",
						  title: "Publicación eliminada",
						  showConfirmButton: false,
						  timer: 1500
						})
						this.obtener()
					}

			    } catch(error){
			    	alert("Error al eliminar la publicación  " + error)
			    }
			  }
			})
		},

		async registrar(){
			if(this.venta.cliente === "" || this.venta.plataforma === "" || this.venta.noDispositivos === "" || this.venta.precio === "" || this.venta.usuario === "" || this.venta.contrasenia === "" || this.venta.fechaInicio === "" || this.venta.fechaFin === ""){
				alert("Coloca los campos marcados con *")
				return

			}
			try {
				let payload = {
					venta: this.venta,
					//accion: 'nuevo'
					accion: this.accionModal === 'Agregar' ? 'nuevo' : 'editar'
				}

				//console.log(payload)
				//return
				let respuesta = await fetch("../controller/Ventas.php",{
					method: "POST",
					headers: {
                        "Content-Type": "application/json"
                    },
					body: JSON.stringify(payload)
				})

				let resultado = await respuesta.json()
				if(resultado){
					let mensaje = this.accion === 'Agregar' ? 'Venta registrada': 'Cambios guardados'
					Swal.fire({
					  position: "top-end",
					  icon: "success",
					  title: mensaje,
					  showConfirmButton: false,
					  timer: 1500
					})
					this.cerrarModal()
					this.obtener()
				}
			} catch(error){
				alert("Error al registrar los datos " + error)
			}
		},

		async obtener(){
			try {
				let payload = {
					accion: 'obtener',
					pagina: this.currentPage, 
					porPagina: this.perPage,
					busqueda: this.searchQuery,
					filtro: this.filtroEstado
				}

				//console.log(payload)
				//return
				let respuesta = await fetch("../controller/Ventas.php",{
					method: "POST",
					headers: {
                        "Content-Type": "application/json"
                    },
					body: JSON.stringify(payload)
				})

				let resultado = await respuesta.json()
				if(resultado){
					this.ventas = resultado.ventas
					this.estados = resultado.estados
					this.totalItems = resultado.total_items
				}
			} catch(error){
				alert("Error al registrar los datos " + error)
			}
		}
	},

	computed: {
        totalPages() {
          return Math.ceil(this.totalItems / this.perPage);
        },
      },
})
</script>
<style>
	@media
only screen and (max-width: 640px) {
  table, thead, tbody, th, td, tr {
    display: block;
  }
  thead tr {
    position: absolute;
    top: -9999px;
    left: -9999px;
  }
  tr { border: 1px solid #ccc; }
  td {
    border: none;
    border-bottom: 1px solid #eee;
    position: relative;
    padding-left: 200px;
    margin-left: 150px;
  }
  td:before {
    position: absolute;
    top: 12px;
    left: 6px;
    width: 200px;
    padding-right: 40px;
    white-space: nowrap;
    margin-left: -150px;
  }
  td:nth-of-type(1):before { content: "Cliente"; }
  td:nth-of-type(2):before { content: "Whatsapp"; }
  td:nth-of-type(3):before { content: "Plataforma"; }
  td:nth-of-type(4):before { content: "Dispositivos";}
  td:nth-of-type(5):before { content: "Precio";}
  td:nth-of-type(6):before { content: "Usuario";}
  td:nth-of-type(7):before { content: "Contraseña";}
  td:nth-of-type(8):before { content: "Fecha Inicio";}
  td:nth-of-type(9):before { content: "Fecha Fin";}
  td:nth-of-type(10):before { content: "Días Restantes";}
  td:nth-of-type(11):before { content: "Estado";}
  td:nth-of-type(12):before { content: "Observación";}
  td:nth-of-type(13):before { content: "Opciones";}
  td:nth-of-type(14):before { content: "Enviar datos/Recordatorio";}
}
</style>